#!/bin/bash
#
# Mount lvm snapshots
# Copyright Daniel Mehrmann (Akusari) 2024
#

#
# settings
#

source /usr/local/etc/make_backup.conf
volume_array=($lvm_volumes)
root_mounted="no"

### mount lvm snapshots ###

for volume in "${volume_array[@]}"; do
   if [ "$volume" == "root" ]; then
      mount -o ro /dev/mapper/${lvm_group}-snap--"${volume}" /mnt || exit 255
      root_mounted="yes"
      continue 
   elif [ "$root_mounted" == "no" ]; then
      echo "Root FS is not mounted! Please put root on first element."
      exit 255
   fi

   mount -o ro /dev/mapper/${lvm_group}-snap--"${volume}" /mnt/"${volume}" || exit 255
done
   
exit 0
