#!/bin/bash
#
# Show current running configuration
# Copyright Daniel Mehrmann (Akusari) 2023
#

### colors ###
RED="31"
GREEN="32"
WHITE="97"
BOLDGREEN="\e[1;${GREEN}m"
BOLDRED="\e[1;${RED}m"
BOLDWHITE="\e[1;${WHITE}m"
ITALICRED="\e[3;${RED}m"
ENDCOLOR="\e[0m"

#
# Daten-Box special
#
if [ "$(cat /etc/hostname)" == "daten-box" ]; then
   echo ""
   echo -e "${BOLDWHITE}### System config ### ${ENDCOLOR}"
   echo ""

   if grep -iqc "isolcpu" /proc/cmdline; then
      echo -e "--> Isolate CPU's ${BOLDGREEN}enabled${ENDCOLOR}"
   else
      echo -e "--> Isolate CPU's ${BOLDRED}disabled${ENDCOLOR}"
   fi

   if grep -iqc "vfio-pci" /proc/cmdline; then
      echo -e "--> Isolate GPU  ${BOLDGREEN} enabled${ENDCOLOR}" 
   else
      echo -e "--> Isolate GPU  ${BOLDRED} disabled${ENDCOLOR}"
   fi
fi

#
# Arch updates
#

if [ -f /usr/local/etc/pacman.motd ]; then
   echo ""
   echo "#####################"
   echo -e "${BOLDWHITE}Available updates:${ENDCOLOR} ${BOLDGREEN}$(cat /usr/local/etc/pacman.motd)${ENDCOLOR}"
   echo "#####################"
   echo ""
fi

#
# Systemd --failed units
#
failed="$(systemctl --failed |grep -v '[LOAD|ACTIVE|SUB]')"
if [[ -n $failed ]]; then
   echo -e "### ${BOLDWHITE}Failed services/timers:${ENDCOLOR} ###"
   echo -e "$failed"
   echo ""
fi

#
# Show motd messages
#
for i in /etc/motd.d/* ; do
   [[ -e "$i" ]] || break # no files listed
   cat "$i"
   echo ""
done
